# $Id: util-vserver.spec.in,v 1.18 2004/02/10 12:18:22 ensc Exp $

%define confdir		%_sysconfdir/vservers
%define confdefaultdir	%confdir/.defaults
%define pkglibdir	%_libdir/%name
%define __chattr	/usr/bin/chattr

Summary:	Linux virtual server utilities
Name:		util-vserver
Version:	0.28.200
Release:	0
Epoch:		0
License:	GPL
Group:		System Environment/Base
URL:		http://savannah.nongnu.org/projects/util-vserver/
Source0:	http://savannah.nongnu.org/download/util-vserver/stable.pkg/%version/%name-%version.tar.bz2
BuildRoot:	%_tmppath/%name-%version-%release-root
Requires:	init(util-vserver)
Requires:	%name-core = %epoch:%version-%release
Requires:	%name-lib  = %epoch:%version-%release
Provides:	vserver = %epoch:%version-%release
Obsoletes:	vserver < %epoch:%version
BuildRequires:	mount vconfig gawk iproute
BuildRequires:	gcc-c++ wget
BuildRequires:	e2fsprogs-devel
Requires(post):	%__chattr
%{!?_without_dietlibc:BuildRequires:	dietlibc >= 0:0.22}

%package lib
Summary:	Dynamic libraries for util-vserver
Group:		System Environment/Libraries

%package core
Summary:	The core-utilities for util-vserver
Group:		Applications/System

%package build
Summary:	Tools which can be used to build vservers
Group:		Applications/System
Requires:	%name = %epoch:%version-%release
Requires:	rpm apt wget binutils tar

%package sysv
Summary:	SysV-initscripts for vserver
Group:		System Environment/Base
Provides:	init(util-vserver)
Requires:	%name = %epoch:%version-%release
Requires:	initscripts

%package legacy
Summary:	Legacy utilities for util-vserver
Group:		Applications/System
Requires:	%name = %epoch:%version-%release

%package devel
Summary:	Header-files and libraries which are needed to develop vserver based applications
Group:		Development/Libraries
Requires:	pkgconfig


%description
This package provides the components and a framework to setup virtual
servers.  A virtual server runs inside a linux server. It is nevertheless
highly independent. As such, you can run various services with normal
configuration. The various vservers can't interact with each other and
can't interact with services in the main server.

This requires a special kernel supporting the new new_s_context and
set_ipv4root system call.

%description lib
%description core
%description build
%description sysv
%description legacy
%description devel


%prep
%setup -q


%build
%configure --with-initrddir=%_initrddir --enable-release \
           %{?_without_dietlibc:--disable-dietlibc}
%__make %{?_smp_mflags}


%install
rm -rf $RPM_BUILD_ROOT
%__make DESTDIR="$RPM_BUILD_ROOT" install install-vserverdir

rm -f $RPM_BUILD_ROOT/%_libdir/*.la

contrib/make-manifest %name $RPM_BUILD_ROOT contrib/manifest.dat


%check || :
%__make check


%clean
rm -rf $RPM_BUILD_ROOT


%post
f="%confdefaultdir/vdirbase"; test -L "$f" -o -e "$f" || ln -s /vservers             "$f"
f="%confdefaultdir/run.rev";  test -L "$f" -o -e "$f" || ln -s /var/run/vservers.rev "$f"

%__chattr +t /vservers || :


%define v_services	httpd named portmap sendmail smb sshd xinetd
%post sysv
/sbin/chkconfig --add vservers
/sbin/chkconfig --add rebootmgr

for i in %v_services; do
	/sbin/chkconfig --add v_$i
done


%preun sysv
test "$1" != 0 || for i in %v_services; do
	/sbin/chkconfig --del v_$i
done

test "$1" != 0 || %{_initrddir}/rebootmgr stop &>/dev/null || :
test "$1" != 0 || /sbin/chkconfig --del rebootmgr
test "$1" != 0 || /sbin/chkconfig --del vservers


%postun sysv
test "$1" = 0  || %{_initrddir}/rebootmgr condrestart >/dev/null || :


%post   lib -p /sbin/ldconfig
%postun lib -p /sbin/ldconfig


%files -f %name-base.list
%defattr(-,root,root,-)
%doc AUTHORS COPYING ChangeLog NEWS README THANKS
%doc doc/FAQ.txt
%dir %pkglibdir
%dir %confdefaultdir
%dir %confdefaultdir/init
%dir %confdefaultdir/apps
%dir %confdefaultdir/apps/pkgmgmt
%dir %confdefaultdir/files
%ghost %confdefaultdir/vdirbase
%ghost %confdefaultdir/run.rev

%attr(000,root,root) %dir /vservers/.pkg
%attr(000,root,root) %dir /vservers

%dir /var/run/vservers
%dir /var/run/vservers.rev


%files lib -f %name-lib.list

%files core -f %name-core.list
%defattr(-,root,root,-)
%dir %pkglibdir


%files build -f %name-build.list
%defattr(-,root,root,-)
%dir %pkglibdir
%dir %confdir/.distributions
%dir %confdir/.distributions/*
%dir %confdir/.distributions/*/apt
%config(noreplace) %confdir/.distributions/*/apt/sources.list


%files legacy -f %name-legacy.list
%defattr(-,root,root,-)
%dir %pkglibdir/legacy


%files sysv
%defattr(-,root,root,-)
%config %_initrddir/*
%config(noreplace) %_sysconfdir/vservers.conf


%files devel -f %name-devel.list
%defattr(-,root,root,-)


%changelog
* Wed Oct  1 2003 Enrico Scholz <enrico.scholz@informatik.tu-chemnitz.de> - 0:0.23.5-0
- Initial build.
