#include <stdio.h>
#include <stdlib.h>
#include <sys/wait.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>

int main (int argc, char *argv[])
{
	if (argc != 3){
		fprintf (stderr,"testlimit nbprocess nbopen\n");
	}else{
		int nbproc = atoi(argv[1]);
		int nbopen = atoi(argv[2]);
		for (int i=0; i<nbproc; i++){
			if (fork()==0){
				int j;
				for (j=0; j<nbopen; j++){
					FILE *fin = fopen ("/proc/self/status","r");
					if (fin == NULL){
						fprintf (stderr,"Can't open %d (%s)\n",errno,strerror(errno));
						break;
					}
				}
				printf ("%d open files, sleeping\n",j);
				sleep (100);
				_exit (0);
			}
		}
		int status;
		while (wait(&status)!=-1);
	}
	return 0;
}

