/*
	Test to see isolation of the various IPC resources
	between security context
*/
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>

int main (int argc, char *argv[])
{
	int ret = -1;
	if (argc < 2){
		fprintf (stderr,
			"testipc createshm\n"
			);
	}else if(strcmp(argv[1],"createshm")==0){
		int id = shmget (1,1024,IPC_CREAT|0666);
		if (id == -1){
			fprintf (stderr,"shmget failed (%s)\n",strerror(errno));
		}else{
			printf ("shmget id %d\n",id);
			void *pt = shmat (id,NULL,0);
			if (pt == NULL){
				fprintf (stderr,"can't shmat to id %d (%s)\n",id,strerror(errno));
			}else{
				strcpy ((char*)pt,"original string");

				printf ("Letting a sub-program attach to this memory\n");
				char tmp[100];
				sprintf (tmp,"./testipc accessshm %d",id);
				int ok = system (tmp);
				printf ("\tSub-program returned %d\n",ok);

				printf ("\tThe segment now hold :%s:\n",(char*)pt);
				shmdt (pt);

				printf ("A sub-program in another context can't attach\n");
				sprintf (tmp,"/usr/sbin/chcontext ./testipc accessshm %d",id);
				ok = system (tmp);
				printf ("\tSub-program returned %d\n",ok);

				printf ("Executing a sub-shell\n");
				system ("/bin/sh");
			}
			printf ("Delete the share memory segment\n");
			if (shmctl (id,IPC_RMID,NULL)==-1){
				fprintf (stderr,"shmctl failed (%s)\n",strerror(errno));
			}else{
				ret = 0;
			}
		}
	}else if(strcmp(argv[1],"accessshm")==0){
		int id = atoi(argv[2]);
		void *pt = shmat (id,NULL,0);
		if (pt == (void*)-1){
			fprintf (stderr,"can't shmat to id %d (%s)\n",id,strerror(errno));
		}else{
			printf ("\tWriting hello in share memory\n");
			strcpy ((char*)pt,"hello");
			ret = 0;
		}
	}else if(strcmp(argv[1],"createsem")==0){
		int id = semget (1,1,IPC_CREAT|0666);
		if (id == -1){
			fprintf (stderr,"semget failed (%s)\n",strerror(errno));
		}else{
			printf ("semget id %d\n",id);

			printf ("Letting a sub-program play with this semaphore\n");
			char tmp[100];
			sprintf (tmp,"./testipc accesssem %d",id);
			int ok = system (tmp);
			printf ("\tSub-program returned %d\n",ok);

			printf ("A sub-program in another context can't use the semaphore\n");
			sprintf (tmp,"/usr/sbin/chcontext ./testipc accesssem %d",id);
			ok = system (tmp);
			printf ("\tSub-program returned %d\n",ok);

			printf ("Executing a sub-shell\n");
			system ("/bin/sh");

			printf ("Delete the semaphore\n");
			if (semctl (id,0,IPC_RMID,NULL)==-1){
				fprintf (stderr,"semctl failed (%s)\n",strerror(errno));
			}else{
				ret = 0;
			}
		}
	}else if(strcmp(argv[1],"accesssem")==0){
		int id = atoi(argv[2]);
		struct sembuf ops[]={
			{0,0,0}
		};
		if (semop (id,ops,1) == -1){
			fprintf (stderr,"can't semop with id %d (%s)\n",id,strerror(errno));
		}else{
			ret = 0;
		}
	}
	return ret;
}
		

