#!/bin/sh
# Prints all the vserver roots used on this server

USR_LIB_VSERVER=/usr/lib/vserver
ETC_VSERVERS=/etc/vservers

source /etc/vservers.conf

printall(){
	echo $VSERVERS_ROOT
	for conf in $ETC_VSERVERS/*.conf
	do
		case $conf in
		$ETC_VSERVERS/\*.conf)
			;;
		*)
			conf=`basename $conf .conf`
			eval `$USR_LIB_VSERVER/printconf.sh --quote $conf`
			echo $VSERVERS_ROOT
			;;
		esac
	done
}
for root in `printall | sort | uniq`
do
	FREE=`df -h $root/. | (read line; read a b c d e; echo $d)`
	echo $root $FREE
done



